*****************************************************************************
* Name:     The CAS Enabler Aplet for the HP39G (and HP40G)
* Language: RPL
* Copyright (c) 2002 by Jordi Hidalgo Lozano <jordi.hidalgo@gmail.com>
*           All rights reserved.
* Versions: 1st Beta (0.01) - September 19, 2002.
*           2nd Beta (0.90) - October 18, 2002.
*           3rd Beta (0.91) - October 21, 2002.
*           4th Beta (0.92) - October 22, 2002.
*           5th Beta (0.93) - October 31, 2002.
*           1.0             - December 2, 2002. Released on November 18, 2005
*                             as Version A.
*****************************************************************************

TITLE CASfor39

INCLUDE common39.h

ASSEMBLE
         NIBASC  \HP39BinB\
         CON(2)  11
         NIBASC  'CAS\00Enabler'
DirStart CON(5)  =DORRP
         CON(3)  #601
         REL(5)  DirEnd
         CON(5)  0
L1       CON(2)  0
RPL

EXTERNAL view7_CAPLET

{
 topic_CAPLET view01_CAPLET view23_CAPLET view45_CAPLET xREADNOTE view7_CAPLET
}

INCLUDE share39.h

ASSEMBLE
        Vfield  L34,IntTable
        CON(5)  =DOHSTR
        REL(5)  endLink
        Link    _Main
        Link    _Entry
        Link    _Toggler
        Link    _CASGrob
        Link    _NoCASGrob
endLink
RPL

DEFINE  Main            INT_00
DEFINE  Entry           INT_01
DEFINE  Toggler         INT_02
DEFINE  CASGrob         INT_03
DEFINE  NoCASGrob       INT_04

ASSEMBLE
        Vfield  IntTable,DirVar
RPL
ASSEMBLE
        CON(5)  =DOHSTR
        REL(5)  endCode
RPL

ASSEMBLE
=CAS?           EQU     #196B4
=AllowCAS       EQU     #196C2
=DisableCAS     EQU     #196D0
=MiniGrob!      EQU     #3F8A0
RPL

NAMELESS _Main
::
 {
  MINUSONE
  { { $ "Start" :: ZERO INT_00 ; } { $ "About" NotesViewUI } }
  StndVar StndEntry StndExit
 }
 BinLookup case EVAL DROP' Entry ' LeaveGraphView ' EnsureMenuOff
 '
 ::
  { { kcEnter :: TakeOver Toggler ; } NULL{} NULL{} NULL{} NULL{} NULL{} }
  ONE KeyFace
 ;
 StndMenu
;

NAMELESS _Entry
::
 RECLAIMDISP TURNMENUOFF NINE FOUR
 ASSEMBLE
        CON(5)  =DOGROB
        CON(5)  #CD
        CON(5)  #13
        CON(5)  #27
        NIBHEX  0F10000E308F30E30FE0CB70E387C1C170E383
        NIBHEX  81E170E3C183E070F7C183E070F7C183F07077
        NIBHEX  C183707877C38370783F8300700C3F0700700C
        NIBHEX  1E0F00700CFF0C30700E1E1870700E0C10E160
        NIBHEX  0E0C10C3E0EF0C3083C97F0CF3830F16000EF1
 RPL
 XYGROBDISP FIFTYFOUR NINE CAS? ITE CASGrob NoCASGrob XYGROBDISP
 TEN FIFTYEIGHT $ "Heiskanen and C.N. Fiechter."
 NINE FIFTYONE $ "CAS by Bernard Parisse, Mika"
 FIFTEEN FORTY $ "(C) 2002 by Jordi Hidalgo"
 TWENTYTWO TWENTYSEVEN $ "Press ENTER to toggle."
 HARDBUFF FOUR
 ZERO_DO (DO)
  4UNROLL DUPLEN$ FOUR #* MiniGrob!
 LOOP DROP
;

NAMELESS _Toggler
::
 CONTEXT@ RAM-WORDNAME ' ID 'CAS\00Enabler EQUALNOTcase DoBadKey
 FIFTYFOUR NINE # 314 BINT222 CAS? ITE
 ::
  OFFSRRP OFFSRRP DisableCAS NoCASGrob
 ;
 ::
  TOSRRP TOSRRP AllowCAS
  ASSEMBLE
        NIBHEX  57720700EB00
  RPL
  CASGrob
 ;
 XYGROBDISP
;

NAMELESS _CASGrob
ASSEMBLE
        CON(5)  =DOGROB
        CON(5)  #11D
        CON(5)  #F
        CON(5)  #46
        NIBHEX  00000000C0060000C000000000C0060000C000000000C
        NIBHEX  0060000C000000000C00600006000000000C003000060
        NIBHEX  878978F36E13870E70CC8F6CC36333CC03706C876683E
        NIBHEX  1336C81603C836681E0B13C81703781338160B137C030
        NIBHEX  F18133C13891F1C8303CC033E138913CCC3036C033B17
        NIBHEX  C8136CE30E3C03E91F781E38330000000000000000000
RPL

NAMELESS _NoCASGrob
ASSEMBLE
        CON(5)  =DOGROB
        CON(5)  #11D
        CON(5)  #F
        CON(5)  #46
        NIBHEX  000000000000000000002000000208000080004400000
        NIBHEX  000100040002200000208000080000000000100100040
        NIBHEX  002000000208000000051405051150050450880220080
        NIBHEX  2288800204010404001444001402802A02880220A8020
        NIBHEX  4011011401444140102802022A8022208820401111150
        NIBHEX  0144054008002A0A88A02828220000000000000000000
RPL

ASSEMBLE
endCode
RPL

ASSEMBLE
        Vfield DirVar,DirCode
RPL
{ }

ASSEMBLE
        Vfield DirCode,DirAlt
RPL
{ }

ASSEMBLE
        Vfield DirAlt,DirNot
        CON(5)  =DOCSTR
        REL(5)  noteEnd
        NIBASC  "\n\xA9'02 by Jordi Hidalgo\n"
        NIBASC  "  HPCC member #1046\n\n"
        NIBASC  "      Version A\n\n"
        NIBASC  "     POSTCARDWARE\n"
        NIBASC  "Send your postcard to:\n"
        NIBASC  "    Jordi Hidalgo\n"
        NIBASC  "  Avda Jaume Recoder\n"
        NIBASC  " 80 1-4, Matar\xF3 08302\n"
        NIBASC  "   Barcelona, Spain"
noteEnd
RPL

ASSEMBLE
        Vfield DirNot,DirEnd
RPL
{ }
