*****************************************************************************
* Modultype:   Saturn Code Object
* Dest.Comp.:  HP 48S, 48SX, 48G, 48G+ and 48GX. Any ROM revision.
* Author:      Jordi Hidalgo <hidalgo@tv3mail.com>
* Description: Converts a graphics string to GROB.
* Input:       2: String of m*n/8 bytes (w/o escape, size or control chars)
*              1: Graphic m x n (blank)
* Output:      1: Graphic m x n (GROB version of the graphics string)
* Copyright:   (C) 2003 by Jordi Hidalgo. All rights reserved.
* Version:     A. Released with Datafile V22N6. December 2003.
*****************************************************************************

CODE
       GOSBVL  =SAVPTR
       C=DAT1  A        addr of ob in level 1 (a grob m x n)
       CD1EX
       D1=D1+  10
       A=DAT1  A        height of grob (n)
       GOSUB   DivBy8   divides A[A] by eight. Number of escape sequences.
       A=A-1   A
       R4=A.F  A        R4=(n/8)-1
       D1=D1+  5
       A=DAT1  A
       R3=A.F  A        R3[A]=width of grob (m)
       SB=0
       GOSUB   DivBy8   If m is not a multiple of 8 (ie. if each row has to be
*                       padded with extra bits) sets sticky bit.
       D1=D1+  5        D1 points to grob data
       D0=C
       D0=D0+  5
       C=DAT0  A        addr of ob in level 2 (a string of m*n/8 chars)
       CD0EX
       D0=D0+  10
       CD0EX
       D0=C
       R0=C.F  A        R0[A] and D0 point to string data

MainLp LC(5)   1        Initializes:
       B=C     A        B=bit mask for grob byte (1 to 128, ie. lsb to msb)
       D=C     A        D=bit mask for string byte (1 to 128, ie. lsb to msb)
       R1=C.F  A        R1[A]=index for width (1 to R3)
       R2=C.F  A        R2[A]=index for height (1 to 8)

RowLp  C=DAT0  2        Reads one byte of string data
       C=C&D   B
       ?C=0    B        Bit D clear?
       GOYES   NoWrt    If so, do nothing
       C=DAT1  2
       C=C!B   B
       DAT1=C  2        otherwise, sets bit B in grob data
NoWrt  D0=D0+  2        Next char
       B=B+B   A        Next grob bit
       LC(5)   #80
       ?B<=C   A        If <= 8
       GOYES   InByte   do nothing
       GOSUB   NxByte   else 8 bits already written, advances to next byte
InByte C=R1
       A=R3
       C=C+1   A
       R1=C.F  A        R1=R1+1
       ?C<=A   A        If R1 <= grob's width
       GOYES   RowLp    goes to RowLp (for R1=1 to grob's width)
       ?SB=0            End of row. Padding required?
       GOYES   NoPad
       GOSUB   NxByte   If so, advances to next byte
NoPad  LC(5)   1
       R1=C.F  A
       C=R2
       LA(5)   8
       C=C+1   A
       R2=C.F  A        R2=R2+1
       ?C<=A   A        Eight rows written?
       GOYES   NxtRow   If not, we're still in the same escape sequence
       C=R4.F  A
       C=C-1   A        If not all escape seqs read,
       GONC    NxtSeq   reads next
       GOSBVL  =GETPTR
       GOVLNG  (=SWAPDROP)+5  otherwise, quits. Drops string. Unsupported
*                             but static in all ROM revs.
NxtSeq R4=C.F  A
       CD0EX
       D0=C
       R0=C.F  A        Resets R0=D0=beginning of string data
       GOTO    MainLp   Reads next escape seq (m x 8)
NxtRow C=R0
       D0=C             Resets R0=D0=beginning of string data
       D=D+D   A        Next string bit
       GOTO    RowLp    Reads next row
NxByte D1=D1+  2        Subroutine. Next grob byte. Resets grob bit.
       LC(5)   1
       B=C     A
       RTN
DivBy8 ASRB.F  A        Subroutine. Divides by 8. Sets SB if not multiple of 8.
       ASRB.F  A
       ASRB.F  A
       RTN
ENDCODE